--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNmarkingParams ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCobj
  local LOCoverrideSwitch = false
  local LOColdShift
  local LOCrmsPath
  local LOCrmsStyle = ""

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---

  --- Function Called If Civil_View_Swept_Object Modifier is Deleted From Object Whilst This Panel Is Active - prevents controls from being used after deletion of modifier
  fn DYNFUNmarkingParamsCallback =
  (
    local LOCnotifyParam = callbacks.notificationParam()
    if try (DYNmarkingParams.LOCobj == LOCnotifyParam[1]) catch (false) then
    (
      for i in DYNmarkingParams.controls do i.enabled = false
    )
  )

  fn DYNFUNmarkingParams FUNobj =
  (
    DYNmarkingParams.LOCobj = FUNobj
    local LOCobjMod = (CVGetMod FUNobj Civil_View_Road_Marking)

    DYNmarkingParams.LOCrmsStyle           = getAppData FUNobj 424; if DYNmarkingParams.LOCrmsStyle == undefined then DYNmarkingParams.LOCrmsStyle = ""

    if LOCobjMod != undefined then
    (
      DYNmarkingParams.LBDYNmatID.text        = "Current Material ID: " + (LOCobjMod.matID as string)
    )

    --- Derive information from AppData and display in panel
    DYNmarkingParams.PKDYNparentMarks.text  = try (FUNobj.parent.name) catch (DYNuiResourcesButtons[15])
    DYNmarkingParams.PKDYNparentSmesh.text  = try (FUNobj.parent.name) catch (DYNuiResourcesButtons[15])
    DYNmarkingParams.SPDYNmarkLength.value  = try ((getAppData FUNobj 426) as float) catch (1.0)
    DYNmarkingParams.SPDYNgapLength.value   = try ((getAppData FUNobj 427) as float) catch (0.0)
    DYNmarkingParams.SPDYNgapCentre.value   = try ((getAppData FUNobj 430) as float) catch (0.0)

    DYNmarkingParams.CODYNcolor.color       = try (sceneMaterials[DYNmatNameMarkings][((getAppData FUNobj 423) as integer)].diffuse) catch (DYNINImarkingColor)
    local LOCwidth = try ((getAppData FUNobj 428) as float) catch (0.1)
    if LOCwidth < 0 then
    (
      DYNmarkingParams.SPDYNmarkWidth.value    = LOCwidth * -1
      DYNmarkingParams.CKDYNuseGlobal.checked  = false
      DYNmarkingParams.LOCoverrideSwitch       = true
      DYNmarkingParams.SPMRKmarkVShift.value   = DYNmarkingParams.LOColdShift = try ((getAppData FUNobj 429) as float) catch (0.0)
      DYNmarkingParams.SPMRKmarkVShift.enabled = true
    )
    else
    (
      DYNmarkingParams.SPDYNmarkWidth.value    = LOCwidth
      DYNmarkingParams.CKDYNuseGlobal.checked  = true
      DYNmarkingParams.LOCoverrideSwitch       = false
      DYNmarkingParams.SPMRKmarkVShift.value   = DYNmarkingParams.LOColdShift = rootNode.DYNrootNodeStore.markVshift
      DYNmarkingParams.SPMRKmarkVShift.enabled = false
    )

    DYNmarkingParams.SPDYNgapCentre.range.y    = DYNmarkingParams.SPDYNmarkWidth.value

    if LOCobjMod != undefined then
    (
      DYNmarkingParams.SPDYNmaxDist.enabled    = DYNmarkingParams.SPDYNspacing.enabled = true
      DYNmarkingParams.SPDYNthreshold.enabled  = if LOCobjMod.type == 0 then false else true
      DYNmarkingParams.SPDYNmaxDist.value      = LOCobjMod.maxDist
      DYNmarkingParams.SPDYNthreshold.value    = LOCobjMod.threshold
      DYNmarkingParams.SPDYNspacing.value      = LOCobjMod.spacing
      DYNmarkingParams.SPDYNmarkHShift.value   = LOCobjMod.OffsetX
      DYNmarkingParams.SPDYNcrossFall.value    = LOCobjMod.cf
      DYNmarkingParams.SPDYNmarkHShift.enabled = true
      DYNmarkingParams.SPDYNcrossFall.enabled  = true

      DYNmarkingParams.SPDYNmarkAngle.value    = 0.0
      DYNmarkingParams.SPDYNmarkAngle.enabled  = false; DYNmarkingParams.LBDYNmarkAngle.enabled      = false

      /* Show whether linked or not (instanced) */
      DYNFUNgatherNodesWithModInstances DYNmarkingParams LOCobjMod
      DYNmarkingParams.PKDYNlinkMarks.pos.x    = 13
      DYNmarkingParams.PKDYNlinkSmesh.pos.x    = 2013
      DYNmarkingParams.LBDYNmarkWidth.pos.x    = 13
      DYNmarkingParams.SPDYNmarkWidth.pos.x    = (DYNiniExplorerWidth - 37)
      DYNmarkingParams.LBDYNmarkAngle.pos.x    = 2013
      DYNmarkingParams.SPDYNmarkAngle.pos.x    = 2101
      DYNmarkingParams.PKDYNparentMarks.pos.x  = 14
      DYNmarkingParams.PKDYNparentSmesh.pos.x  = 2014
    )
    else
    (
      /* Chevrons Detected */
      if (CVGetMod FUNobj Civil_View_Spline_to_Mesh) != undefined then
      (
        for i in DYNmarkingParams.controls do
        (
          if \
            i != DYNmarkingParams.PKDYNparentSmesh and \
            i != DYNmarkingParams.LBDYNmarkLength  and \
            i != DYNmarkingParams.SPDYNmarkLength  and \
            i != DYNmarkingParams.LBDYNgapLength   and \
            i != DYNmarkingParams.SPDYNgapLength   and \
            i != DYNmarkingParams.LBDYNcolor       and \
            i != DYNmarkingParams.CODYNcolor       and \
            i != DYNmarkingParams.BUDYNcolor       and \
            i != DYNmarkingParams.PKDYNlinkSmesh   and \
            i != DYNmarkingParams.LBDYNmarkAngle   and \
            i != DYNmarkingParams.GBDYNgroup01     and \
            i != DYNmarkingParams.GBDYNgroup02     and \
            i != DYNmarkingParams.GBDYNgroup03     and \
            i != DYNmarkingParams.GBDYNgroup04     and \
            i != DYNmarkingParams.GBDYNgroup06     and \
            i != DYNmarkingParams.CKDYNuseGlobal   and \
            i != DYNmarkingParams.LBMRKmarkVShift  and \
            i != DYNmarkingParams.LBDYNmarkHShift  and \
            i != DYNmarkingParams.SPDYNmarkHShift  and \
            i != DYNmarkingParams.SPDYNcrossFall   and \
            i != DYNmarkingParams.SPDYNmarkAngle   \
            then i.enabled = false else i.enabled = true
        )
        DYNmarkingParams.SPDYNmarkAngle.value    = (CVGetMod FUNobj Civil_View_Spline_to_Mesh).rotation
        DYNmarkingParams.SPDYNmarkHShift.value   = (CVGetMod FUNobj Civil_View_Spline_to_Mesh).offsetx

        /* Show whether linked or not (instanced) */
        DYNFUNgatherNodesWithModInstances DYNmarkingParams (CVGetMod FUNobj Civil_View_Spline_to_Mesh)
        DYNmarkingParams.PKDYNlinkMarks.pos.x   = 2013
        DYNmarkingParams.PKDYNlinkSmesh.pos.x   = 13
        DYNmarkingParams.LBDYNmarkWidth.pos.x   = 2013
        DYNmarkingParams.SPDYNmarkWidth.pos.x   = 2101
        DYNmarkingParams.LBDYNmarkAngle.pos.x   = 13
        DYNmarkingParams.SPDYNmarkAngle.pos.x   = (DYNiniExplorerWidth - 37)
        DYNmarkingParams.PKDYNparentMarks.pos.x = 2014
        DYNmarkingParams.PKDYNparentSmesh.pos.x = 14
      )
      else
      (
        for i in DYNmarkingParams.controls do i.enabled = false
        DYNmarkingParams.CBDYNlinked.checked     = false
        DYNmarkingParams.CBDYNlinked.text        = DYNuiResourcesButtons[37]
      )
    )
  )

  fn DYNFUNupdateCurrentMarking =
  (
    --- New Road Marking Object Detected - just update parameters of existing object, no need to recreate ------------------------------------------------------
    if (CVGetMod DYNmarkingParams.LOCobj Civil_View_Road_Marking) != undefined then
    (
      DYNFUNmodifyMarks (CVGetMod DYNmarkingParams.LOCobj Civil_View_Road_Marking) DYNmarkingParams.LOCobj.material [DYNmarkingParams.SPDYNmarkLength.value,DYNmarkingParams.SPDYNgapLength.value,DYNmarkingParams.SPDYNmarkWidth.value] DYNmarkingParams.CODYNcolor.color DYNmarkingParams.SPMRKmarkVShift.value [DYNmarkingParams.SPDYNmarkHShift.value, DYNmarkingParams.SPDYNcrossFall.value] [DYNmarkingParams.SPDYNspacing.value, DYNmarkingParams.SPDYNthreshold.value, DYNmarkingParams.SPDYNmaxDist.value] DYNmarkingParams.SPDYNgapCentre.value
      DYNFUNgenObjAppData DYNmarkingParams.LOCobj "10" (CVGetMod DYNmarkingParams.LOCobj Civil_View_Road_Marking).matID "" (DYNFUNgetLocalTime()) (DYNmarkingParams.SPDYNmarkLength.value as string) (DYNmarkingParams.SPDYNgapLength.value as string) ((if DYNmarkingParams.LOCoverrideSwitch then (-DYNmarkingParams.SPDYNmarkWidth.value) else (DYNmarkingParams.SPDYNmarkWidth.value)) as string)
      setAppData DYNmarkingParams.LOCobj 429 (DYNmarkingParams.SPMRKmarkVShift.value as string)
      setAppData DYNmarkingParams.LOCobj 430 (DYNmarkingParams.SPDYNgapCentre.value as string)

      /* Update AppData for all other nodes which use instances of this Civil_View_Road_Marking modifier (modifier itself updates automatically) */
      local LOCinstances = for i in (refs.dependents (CVGetMod DYNmarkingParams.LOCobj Civil_View_Road_Marking)) where isvalidnode i collect i
      for i in LOCinstances do
      (
        for ii = 421 to 430 do (if ii != 425 and (getAppData DYNmarkingParams.LOCobj ii) != undefined then (setAppData i ii (getAppData DYNmarkingParams.LOCobj ii)))
      )
    )

    --- Chevron Road Marking Object Detected -------------------------------------------------------------------------------------------------------------------
    if (CVGetMod DYNmarkingParams.LOCobj Civil_View_Spline_to_Mesh) != undefined then
    (
      DYNFUNmodifyChevrons (CVGetMod DYNmarkingParams.LOCobj Civil_View_Spline_to_Mesh) DYNmarkingParams.LOCobj.material [DYNmarkingParams.SPDYNmarkLength.value,DYNmarkingParams.SPDYNgapLength.value,DYNmarkingParams.SPDYNmarkWidth.value] DYNmarkingParams.CODYNcolor.color DYNmarkingParams.SPMRKmarkVShift.value [DYNmarkingParams.SPDYNmarkHShift.value, 0.0] [DYNmarkingParams.SPDYNspacing.value, DYNmarkingParams.SPDYNthreshold.value, DYNmarkingParams.SPDYNmaxDist.value] DYNmarkingParams.SPDYNmarkAngle.value
      DYNFUNgenObjAppData DYNmarkingParams.LOCobj "10" (CVGetMod DYNmarkingParams.LOCobj Civil_View_Spline_to_Mesh).matID "" (DYNFUNgetLocalTime()) (DYNmarkingParams.SPDYNmarkLength.value as string) (DYNmarkingParams.SPDYNgapLength.value as string) ((if DYNmarkingParams.LOCoverrideSwitch then (-DYNmarkingParams.SPDYNmarkWidth.value) else (DYNmarkingParams.SPDYNmarkWidth.value)) as string)
      setAppData DYNmarkingParams.LOCobj 429 (DYNmarkingParams.SPMRKmarkVShift.value as string)

      /* Update AppData for all other nodes which use instances of this Civil_View_Spline_to_Mesh modifier (modifier itself updates automatically) */
      local LOCinstances = for i in (refs.dependents (CVGetMod DYNmarkingParams.LOCobj Civil_View_Spline_to_Mesh)) where isvalidnode i collect i
      for i in LOCinstances do
      (
        for ii = 421 to 429 do (if ii != 425 and (getAppData DYNmarkingParams.LOCobj ii) != undefined then (setAppData i ii (getAppData DYNmarkingParams.LOCobj ii)))
      )
    )

    --- Update Panel
    DYNmarkingParams.DYNFUNmarkingParams DYNmarkingParams.LOCobj
    DYNproperties.DYNFUNupdPropertiesPanel()
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  groupbox GBDYNgroup01    pos:[4,7]     width:(DYNiniExplorerWidth - 21) height:46
  pickbutton PKDYNparentMarks pos:[14,26]   align:#center width:(DYNiniExplorerWidth - 38) filter:DYNFUNshapeFilter
  pickbutton PKDYNparentSmesh pos:[14,26]   align:#center width:(DYNiniExplorerWidth - 38) filter:DYNFUNclosedShapeFilter

  groupbox GBDYNgroup02     pos:[4,58]    width:(DYNiniExplorerWidth - 21) height:104
  label LBDYNmarkWidth      pos:[13,79]   align:#left
  label LBDYNmarkAngle      pos:[13,79]   align:#left
  label LBDYNmarkLength     pos:[13,100]  align:#left
  label LBDYNgapLength      pos:[13,121]  align:#left
  label LBDYNgapCentre      pos:[13,142]  align:#left

  spinner SPDYNmarkWidth    pos:[(DYNiniExplorerWidth - 96),77]  fieldwidth:60 range:[0.025,1000.0,1]  scale:0.05 type:#worldunits align:#right
  spinner SPDYNmarkAngle    pos:[(DYNiniExplorerWidth - 96),77]  fieldwidth:60 range:[-360.0,360.0,0] scale:0.05 type:#float align:#right
  spinner SPDYNmarkLength   pos:[(DYNiniExplorerWidth - 96),98]  fieldwidth:60 range:[0.1,1000.0,1]    scale:0.05 type:#worldunits align:#right
  spinner SPDYNgapLength    pos:[(DYNiniExplorerWidth - 96),119] fieldwidth:60 range:[0.0,1000.0,1]    scale:0.05 type:#worldunits align:#right
  spinner SPDYNgapCentre    pos:[(DYNiniExplorerWidth - 96),140] fieldwidth:60 range:[0.0,1000.0,0]    scale:0.05 type:#worldunits align:#right

  groupbox GBDYNgroup03     pos:[4,167]   width:(DYNiniExplorerWidth - 21) height:66
  label LBDYNcolor          pos:[13,186]  align:#left
  colorpicker CODYNcolor    pos:[(DYNiniExplorerWidth - 98),184] fieldwidth:55 height:17 pos:[55,140]
  button BUDYNcolor         pos:[(DYNiniExplorerWidth - 37),184] width:12 height:18
  button BUDYNapply         pos:[13,206]  align:#center width:(DYNiniExplorerWidth - 38) enabled:false

  groupbox GBDYNgroup04     pos:[4,238]   width:(DYNiniExplorerWidth - 21) height:103
  checkbox CKDYNuseGlobal   pos:[13,257]  align:#left
  label LBMRKmarkVShift     pos:[13,277]  align:#left
  label LBDYNmarkHShift     pos:[13,298]  align:#left
  label LBDYNcrossFall      pos:[13,319]  align:#left
  spinner  SPMRKmarkVShift  pos:[(DYNiniExplorerWidth - 96),277] fieldwidth:60 type:#worldunits range:[-1000,1000,0] scale:0.001 enabled:false
  spinner  SPDYNmarkHShift  pos:[(DYNiniExplorerWidth - 96),298] fieldwidth:60 type:#worldunits range:[-1000,1000,0] scale:0.010 enabled:false
  spinner  SPDYNcrossFall   pos:[(DYNiniExplorerWidth - 96),319] fieldwidth:60 type:#float range:[-10.0,10,0] scale:0.010 enabled:false

  groupbox GBDYNgroup05     pos:[4,346]   width:(DYNiniExplorerWidth - 21) height:83
  label LBDYNspacing        pos:[13,367]  align:#left
  label LBDYNthreshold      pos:[13,388]  align:#left
  label LBDYNmaxDist        pos:[13,409]  align:#left
  spinner SPDYNspacing      pos:[(DYNiniExplorerWidth - 96),365] fieldwidth:60 range:[0.1,999.9,1] scale:0.1 type:#worldunits align:#right
  spinner SPDYNthreshold    pos:[(DYNiniExplorerWidth - 96),386] fieldwidth:60 range:[0.0,999.9,1] scale:0.1 type:#float align:#right
  spinner SPDYNmaxDist      pos:[(DYNiniExplorerWidth - 96),407] fieldwidth:60 range:[0.0,999.9,1] scale:0.1 type:#worldunits align:#right

  groupbox GBDYNgroup06     pos:[4,434]   width:(DYNiniExplorerWidth - 21) height:92
  checkbutton CBDYNlinked   pos:[13,453]  width:(DYNiniExplorerWidth - 38) highlightColor:DYNINIhighlightColor
  pickbutton PKDYNlinkMarks pos:[13,479]  width:(DYNiniExplorerWidth - 38) highlightColor:DYNINIhighlightColor filter:DYNFUNdynMarksFilter
  pickbutton PKDYNlinkSmesh pos:[13,479]  width:(DYNiniExplorerWidth - 38) highlightColor:DYNINIhighlightColor filter:DYNFUNdynSmeshFilter
  label LBDYNmatID align:#center

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNmarkingParams open do
  (
    DYNmarkingParams.title = DYNuiRolloutNames[15]

    --- Add Callback To Detect If Spline Modifier Is Deleted While This Panel Is Open
    /* If this is not detected, modifying params in this panel can cause script error after modifier has been deleted */
    callbacks.removescripts id:#DYNmarkingParams
    callbacks.addscript #postModifierDeleted "DYNmarkingParams.DYNFUNmarkingParamsCallback()" id:#DYNmarkingParams

    GBDYNgroup01.text    = DYNuiResourcesGroups[14]
    GBDYNgroup02.text    = DYNuiResourcesGroups[48]
    GBDYNgroup03.text    = DYNuiResourcesGroups[49]
    GBDYNgroup04.text    = DYNuiResourcesGroups[50]
    GBDYNgroup05.text    = DYNuiResourcesGroups[51]
    GBDYNgroup06.text    = DYNuiResourcesGroups[1]

    BUDYNcolor.text      = DYNuiResourcesButtons[36]
    PKDYNlinkMarks.text  = DYNuiResourcesButtons[24]
    PKDYNlinkSmesh.text  = DYNuiResourcesButtons[24]
    BUDYNapply.text      = DYNuiResourcesButtons[55]

    CKDYNuseGlobal.text  = DYNuiResourcesLabels[178]
    LBDYNmarkWidth.text  = DYNuiResourcesLabels[29]
    LBDYNcolor.text      = DYNuiResourcesLabels[56]
    LBDYNcrossFall.text  = DYNuiResourcesLabels[11]
    LBDYNmarkAngle.text  = DYNuiResourcesLabels[179]
    LBDYNmarkLength.text = DYNuiResourcesLabels[54]
    LBDYNgapLength.text  = DYNuiResourcesLabels[55]
    LBDYNgapCentre.text  = DYNuiResourcesLabels[180]
    LBMRKmarkVShift.text = DYNuiResourcesLabels[92]
    LBDYNmarkHShift.text = DYNuiResourcesLabels[181]
    LBDYNspacing.text    = DYNuiResourcesLabels[182]
    LBDYNthreshold.text  = DYNuiResourcesLabels[183]
    LBDYNmaxDist.text    = DYNuiResourcesLabels[184]

    GBDYNgroup06.height = 72
    LBDYNmatID.pos.y += 7
  )

  on DYNmarkingParams close do
  (
    callbacks.removescripts id:#DYNmarkingParams
    LOCobj = undefined
  )

  on CKDYNuseGlobal changed arg do
  (
    undo off
    (
      SPMRKmarkVShift.enabled = not arg
      if arg then
      (
        DYNmarkingParams.LOCoverrideSwitch = false
        setAppData LOCobj 428 (SPDYNmarkWidth.value as string)
        DYNFUNapplyShift LOCobj SPMRKmarkVShift.value rootNode.DYNrootNodeStore.markVshift
        SPMRKmarkVShift.value = LOColdShift = rootNode.DYNrootNodeStore.markVshift
      )
      else
      (
        DYNmarkingParams.LOCoverrideSwitch = true
        setAppData LOCobj 428 ((SPDYNmarkWidth.value * -1) as string)

        --- See if an override value has been used on this object before, and if so use that value
        local LOCpreviousShift = try ((getAppData LOCobj 429) as float) catch ()
        if LOCpreviousShift != undefined then
        (
          DYNFUNapplyShift LOCobj SPMRKmarkVShift.value LOCpreviousShift
          SPMRKmarkVShift.value = LOColdShift = LOCpreviousShift
        )
      )

      --- Apply AppData Changes to all instances of this modifier
      if (CVGetMod LOCobj Civil_View_Spline_to_Mesh) != undefined then
      (
        local LOCinstances = for i in (refs.dependents (CVGetMod LOCobj Civil_View_Spline_to_Mesh)) where isvalidnode i collect i
        for i in LOCinstances do (if classOf (CVGetMod i Civil_View_Spline_to_Mesh) == Civil_View_Spline_to_Mesh then (setAppData i 428 (getAppData LOCobj 428)))
      )
      if (CVGetMod LOCobj Civil_View_Road_Marking) != undefined then
      (
        local LOCinstances = for i in (refs.dependents (CVGetMod LOCobj Civil_View_Road_Marking)) where isvalidnode i collect i
        for i in LOCinstances do (if classOf (CVGetMod i Civil_View_Road_Marking) == Civil_View_Road_Marking then (setAppData i 428 (getAppData LOCobj 428)))
      )
    )
  )

  on SPMRKmarkVShift entered do
  (
    undo off
    (
      DYNFUNapplyShift LOCobj LOColdShift SPMRKmarkVShift.value
      setAppData LOCobj 429 (SPMRKmarkVShift.value as string)
      LOColdShift = SPMRKmarkVShift.value

      --- Apply AppData Changes to all instances of this modifier
      if (CVGetMod LOCobj Civil_View_Spline_to_Mesh) != undefined then
      (
        local LOCinstances = for i in (refs.dependents (CVGetMod LOCobj Civil_View_Spline_to_Mesh)) where isvalidnode i collect i
        for i in LOCinstances do (if classOf (CVGetMod i Civil_View_Spline_to_Mesh) == Civil_View_Spline_to_Mesh and (getAppData LOCobj 429) != undefined then (setAppData i 429 (getAppData LOCobj 429)))
      )
      if (CVGetMod LOCobj Civil_View_Road_Marking) != undefined then
      (
        local LOCinstances = for i in (refs.dependents (CVGetMod LOCobj Civil_View_Road_Marking)) where isvalidnode i collect i
        for i in LOCinstances do (if classOf (CVGetMod i Civil_View_Road_Marking) == Civil_View_Road_Marking and (getAppData LOCobj 429) != undefined then (setAppData i 429 (getAppData LOCobj 429)))
      )
    )
  )

  on SPDYNmarkHShift changed arg do
  (
    undo off
    (
      if (CVGetMod LOCobj Civil_View_Road_Marking) != undefined then
      (
        (CVGetMod LOCobj Civil_View_Road_Marking).offsetx = arg
      )
      if (CVGetMod LOCobj Civil_View_Spline_to_Mesh) != undefined then
      (
        (CVGetMod LOCobj Civil_View_Spline_to_Mesh).offsetx = arg
      )
    )
  )

  on SPDYNcrossFall changed arg do
  (
    undo off
    (
      if (CVGetMod LOCobj Civil_View_Road_Marking) != undefined then
      (
        (CVGetMod LOCobj Civil_View_Road_Marking).cf = arg
      )
    )
  )


  on SPDYNmarkWidth  entered do
  (
    SPDYNgapCentre.range.y = SPDYNmarkWidth.value
    if SPDYNgapCentre.range.y < SPDYNgapCentre.value then SPDYNgapCentre.value = SPDYNgapCentre.range.y
    DYNFUNupdateCurrentMarking()

    if CKDYNuseGlobal.checked then
    (
      setAppData LOCobj 428 (SPDYNmarkWidth.value as string)
    )
    else
    (
      setAppData LOCobj 428 ((SPDYNmarkWidth.value * -1) as string)
    )

    --- Apply AppData Changes to all instances of this modifier
    local LOCinstances = for i in (refs.dependents (CVGetMod LOCobj Civil_View_Road_Marking)) where isvalidnode i collect i
    for i in LOCinstances do (if classOf (CVGetMod i Civil_View_Road_Marking) == Civil_View_Road_Marking then (setAppData i 428 (getAppData LOCobj 428)))
  )
  on SPDYNmarkWidth  changed arg do
  (
    undo off
    (
      (CVGetMod LOCobj Civil_View_Road_Marking).width = arg
    )
  )

  on SPDYNmarkLength entered do (DYNFUNupdateCurrentMarking())
  on SPDYNgapLength  entered do (DYNFUNupdateCurrentMarking())
  on SPDYNgapCentre  entered do (DYNFUNupdateCurrentMarking())

  on BUDYNcolor      pressed do (CODYNcolor.color = DYNINImarkingColor; DYNFUNupdateCurrentMarking())
  on CODYNcolor  changed arg do BUDYNapply.enabled = true

  on SPDYNmarkAngle  changed arg do (CVGetMod LOCobj Civil_View_Spline_to_Mesh).rotation = arg
  on SPDYNthreshold  changed arg do (CVGetMod LOCobj Civil_View_Road_Marking).threshold  = arg
  on SPDYNspacing    changed arg do (CVGetMod LOCobj Civil_View_Road_Marking).spacing    = arg
  on SPDYNmaxDist    changed arg do (CVGetMod LOCobj Civil_View_Road_Marking).maxDist    = arg

  on PKDYNparentMarks picked LOCnewParent do
  (
    if DYNmarkingParams.open do
    (
      undo off
      (
        if superClassOf LOCnewParent == shape then
        (
          DYNFUNloadVSPnodeCallBacks false
          (
            local LOColdObj = LOCobj
            local LOCmarkFreeze = LOCobj.isFrozen
            local LOCobjArray = DYNFUNcreateMarks #(LOCnewParent) LOCrmsStyle SPMRKmarkVShift.value LOCmarkFreeze (DYNFUNgetLocalTime()) CODYNcolor.color [SPDYNmarkLength.value,SPDYNgapLength.value,SPDYNmarkWidth.value] LOCoverrideSwitch false sceneMaterials (CVGetMod LOColdObj Civil_View_Road_Marking) true SPDYNgapCentre.value SPDYNmarkHShift.value SPDYNcrossfall.value
            if LOCobjArray.count > 0 then LOCobj = LOCobjArray[1]
            local LOCsuccessSwitch = DYNFUNapplyModifierInstance Civil_View_Road_Marking LOCobj LOColdObj true
            if LOCsuccessSwitch and isValidNode LOColdObj then delete LOColdObj
          )
          DYNFUNloadVSPnodeCallBacks true
          DYNFUNnodeCreatedCallback()
          if isValidNode LOCobj then select LOCobj else clearSelection()
        )
      )
    )
  )

  on PKDYNparentSmesh picked LOCnewParent do
  (
    if DYNmarkingParams.open do
    (
      undo off
      (
        if superClassOf LOCnewParent == shape then
        (
          DYNFUNloadVSPnodeCallBacks false
          (
            local LOColdObj = LOCobj
            local LOCmarkFreeze = LOCobj.isFrozen
            local LOCobjArray = DYNFUNcreateChevrons #(LOCnewParent) LOCrmsStyle SPMRKmarkVShift.value LOCmarkFreeze (DYNFUNgetLocalTime()) CODYNcolor.color [SPDYNmarkLength.value,SPDYNgapLength.value,SPDYNmarkWidth.value] LOCoverrideSwitch false sceneMaterials (CVGetMod LOColdObj Civil_View_Road_Marking) true SPDYNmarkAngle.value
            if LOCobjArray.count > 0 then LOCobj = LOCobjArray[1]
            local LOCsuccessSwitch = DYNFUNapplyModifierInstance Civil_View_Spline_to_Mesh LOCobj LOColdObj true
            if LOCsuccessSwitch and isValidNode LOColdObj then delete LOColdObj
          )
          DYNFUNloadVSPnodeCallBacks true
          DYNFUNnodeCreatedCallback()
          if isValidNode LOCobj then select LOCobj else clearSelection()
        )
      )
    )
  )


  on CBDYNlinked changed arg do
  (
    --- For Linear Road Markings
    if (CVGetMod LOCobj Civil_View_Road_Marking) != undefined then
    (
      if arg == false and (InstanceMgr.CanMakeModifiersUnique LOCobj (CVGetMod LOCobj Civil_View_Road_Marking)) then
      (
        if (queryBox (DYNuiResourcesQueries[10]) title:DYNuiResourcesTitlebars[2]) then
        (
          InstanceMgr.makeModifiersUnique LOCobj (CVGetMod LOCobj Civil_View_Road_Marking) #prompt
        )
        else CBDYNlinked.checked = true
      )
      DYNFUNmarkingParams LOCobj
    )

    --- For Chevron Road Markings
    if (CVGetMod LOCobj Civil_View_Spline_to_Mesh) != undefined then
    (
      if arg == false and (InstanceMgr.CanMakeModifiersUnique LOCobj (CVGetMod LOCobj Civil_View_Spline_to_Mesh)) then
      (
        if (queryBox (DYNuiResourcesQueries[10]) title:DYNuiResourcesTitlebars[2]) then
        (
          InstanceMgr.makeModifiersUnique LOCobj (CVGetMod LOCobj Civil_View_Spline_to_Mesh) #prompt
        )
        else CBDYNlinked.checked = true
      )
      DYNFUNmarkingParams LOCobj
    )
  )

  on PKDYNlinkMarks picked arg do
  (
    DYNFUNapplyModifierInstance Civil_View_Road_Marking LOCobj arg true
    DYNFUNmarkingParams LOCobj
  )

  on PKDYNlinkSmesh picked arg do
  (
    DYNFUNapplyModifierInstance Civil_View_Spline_to_Mesh LOCobj arg true
    DYNFUNmarkingParams LOCobj
  )

  on BUDYNapply pressed do
  (
    DYNFUNupdateCurrentMarking()
  )
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQDH2PczX+t1mdr3/ewG3yazoeR1pMu+3OjW
-- pcZ1JzBAvbt89RhDvzCUtTo/i+1QUXNf54On7CwHyQCeMBlkJ4bsWBJKJVH+sioF
-- yqpLWRw1GgPKOlCkXTw6UNniKZxe2PwmBU4+AcZA9kj7EaQh+NDCkK19kJE5ORxq
-- QuHymtXRRnT9NvABXG9KkvQPd/GV3wX9ONVjXyF3irGQEaADlzSJPbz9330hoAOn
-- LHZn01SNJknE8qKw+chdqc2sH20i+xp3Sn0xlDcLXYUl/cv2GQv+Y9TBYNF+1yal
-- rIaDy8lXbet89k5S1sIP5wcfHdAiq6g+ZUu7qQuzYYmhy9jrSCPa
-- -----END-SIGNATURE-----